﻿using System;
using System.Collections.Generic;
using System.IO;

namespace memoQSampleCMSConnector
{
	internal class TransfermemoQ2CMS
	{
		private Mode mode;

		public TransfermemoQ2CMS()
		{
			ProcessTransfer();
		}

		private void ProcessTransfer()
		{
			try
			{
				Log.AddLog("Checking for translated files in memoQ...", MessageType.MajorInfo);

				Dictionary<string, Stream> downloadedFiles = mQCMSAPI_Session.GetTranslations();

				if (downloadedFiles.Count > 0)
				{
					CMS_Session.DeliverTranslations(downloadedFiles);
					Log.AddLog("Completed translations transferred to CMS.", MessageType.MajorInfo);
				}
				else
				{
					Log.AddLog("No new files to deliver to CMS.", MessageType.MajorInfo);
				}
			}
			catch (Exception ex)
			{
				Log.AddLog("memoQ to CMS transfer error: " + ex.Message, MessageType.Error);
			}
		}
	}
}